//
//  CRMaterial.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 6/2/09.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRSceneItemVisual.h"

extern NSString* const CRMaterialOutputImagesKey;

//////////////////////////////////////////////////////////////////////
// Material
//////////////////////////////////////////////////////////////////////
@interface CRMaterial : CRSceneItemVisual <CRLibraryItem, CRDraggable>
{
@protected
	NSString*	name;
	NSString*	category;
	NSSet*		tags;
	NSDate*		lastModified;
	BOOL		isSystem;
	
@private
	BOOL		observersRegistered;
}

// CRLibraryItem
@property (nonatomic, copy)		NSString*	name;
@property (nonatomic, copy)		NSString*	category;
@property (nonatomic, copy)		NSSet*		tags;
@property (nonatomic, copy)		NSDate*		lastModified;
@property (nonatomic, assign)	BOOL		isSystem;

- (NSArray *)flushableProperties;
- (void)transferUserDataFromItem:(id<CRLibraryItem>)item;

// Material
@property (nonatomic, readonly)	NSArray*	outputImages;	// defalt returns a single "outputImage", but some materials can ganerate few images

// Quality, Material can ignore this method!
- (void)setRequestedOutputSize:(NSSize)size;

// Basic
+ (id)material;
- (NSString *)materialDescription;

// Draggable
+ (NSArray *)supportedDragTypes;
+ (void)writeObjects:(NSArray *)objects toPasteboard:(NSPasteboard *)pboard;
+ (BOOL)pasteboardContainsObjects:(NSPasteboard *)pboard;
+ (NSArray *)objectsFromPasteboard:(NSPasteboard *)pboard;

@end